/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import fi.dy.masa.malilib.util.nbt.NbtUtils;
import fi.dy.masa.malilib.util.nbt.NbtView;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_11368;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_4482;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8242;
import net.minecraft.class_8514;
import net.minecraft.class_8966;
import net.minecraft.class_9296;
import org.apache.commons.lang3.tuple.Pair;

public class NbtBlockUtils {
    @Nullable
    public static class_2591<?> getBlockEntityTypeFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10545("id")) {
            return class_7923.field_41181.method_17966(class_2960.method_12829((String)nbt.method_68564("id", ""))).orElse(null);
        }
        return null;
    }

    @Nullable
    public static class_2561 getCustomNameFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry, String key) {
        NbtView view = NbtView.getReader(nbt, registry);
        return class_2586.method_59894((class_11368)Objects.requireNonNull(view.getReader()), (String)key);
    }

    public static class_2487 setBlockEntityTypeToNbt(class_2591<?> type, @Nullable class_2487 nbtIn) {
        class_2487 nbt = new class_2487();
        class_2960 id = class_2591.method_11033(type);
        if (id != null) {
            if (nbtIn != null) {
                nbtIn.method_10582("id", id.toString());
                return nbtIn;
            }
            nbt.method_10582("id", id.toString());
        }
        return nbt;
    }

    public static Set<Integer> getDisabledSlotsFromNbt(@Nonnull class_2487 nbt) {
        HashSet<Integer> list = new HashSet<Integer>();
        if (nbt.method_10545("disabled_slots")) {
            int[] is;
            for (int j : is = nbt.method_10561("disabled_slots").orElse(new int[0])) {
                list.add(j);
            }
        }
        return list;
    }

    public static Pair<class_6880<class_1291>, class_6880<class_1291>> getBeaconEffectsFromNbt(@Nonnull class_2487 nbt) {
        Set effects = class_2580.field_11801.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        class_6880 primary = null;
        class_6880 secondary = null;
        if (nbt.method_10545("primary_effect")) {
            primary = nbt.method_67491("primary_effect", class_7923.field_41174.method_40294()).filter(effects::contains).orElse(null);
        }
        if (nbt.method_10545("secondary_effect")) {
            secondary = nbt.method_67491("secondary_effect", class_7923.field_41174.method_40294()).filter(effects::contains).orElse(null);
        }
        return Pair.of(primary, secondary);
    }

    public static Pair<List<class_4482.class_9309>, class_2338> getBeesDataFromNbt(@Nonnull class_2487 nbt) {
        List bees = new ArrayList();
        class_2338 flower = class_2338.field_10980;
        if (nbt.method_10545("bees")) {
            bees = nbt.method_67491("bees", class_4482.class_9309.field_49412).orElse(List.of());
        }
        if (nbt.method_10545("flower_pos")) {
            flower = NbtUtils.getPosCodec(nbt, "flower_pos");
        }
        return Pair.of(bees, (Object)flower);
    }

    public static Pair<Integer, class_8514.class_8515> getSkulkSensorVibrationsFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        class_8514.class_8515 data = null;
        int lastFreq = -1;
        if (nbt.method_10545("last_vibration_frequency")) {
            lastFreq = nbt.method_68083("last_vibration_frequency", 0);
        }
        if (nbt.method_10545("listener")) {
            data = nbt.method_67492("listener", class_8514.class_8515.field_44640, (DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560)).orElseGet(class_8514.class_8515::new);
        }
        return Pair.of((Object)lastFreq, data);
    }

    public static Pair<Long, class_2338> getExitPortalFromNbt(@Nonnull class_2487 nbt) {
        long age = -1L;
        class_2338 pos = class_2338.field_10980;
        if (nbt.method_10545("Age")) {
            age = nbt.method_68080("Age", -1L);
        }
        if (nbt.method_10545("exit_portal")) {
            pos = NbtUtils.getPosCodec(nbt, "exit_portal");
        }
        return Pair.of((Object)age, (Object)pos);
    }

    public static Pair<Pair<class_8242, class_8242>, Boolean> getSignTextFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        AtomicReference<Object> front = new AtomicReference<Object>(null);
        AtomicReference<Object> back = new AtomicReference<Object>(null);
        boolean waxed = false;
        if (nbt.method_10545("front_text")) {
            class_8242.field_43298.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10580("front_text")).resultOrPartial().ifPresent(front::set);
        }
        if (nbt.method_10545("back_text")) {
            class_8242.field_43298.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10580("back_text")).resultOrPartial().ifPresent(back::set);
        }
        if (nbt.method_10545("is_waxed")) {
            waxed = nbt.method_10577("is_waxed").orElse(false);
        }
        return Pair.of((Object)Pair.of((Object)front.get(), (Object)back.get()), (Object)waxed);
    }

    public static Pair<class_1799, Integer> getBookFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        class_1799 book = class_1799.field_8037;
        int current = -1;
        if (nbt.method_10545("Book")) {
            book = nbt.method_67492("Book", class_1799.field_24671, (DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560)).orElse(class_1799.field_8037);
        }
        if (nbt.method_10545("Page")) {
            current = nbt.method_68083("Page", -1);
        }
        return Pair.of((Object)book, (Object)current);
    }

    public static Pair<class_9296, Pair<class_2960, class_2561>> getSkullDataFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        class_9296 profile = null;
        class_2960 note = null;
        class_2561 name = null;
        if (nbt.method_10545("note_block_sound")) {
            note = nbt.method_67491("note_block_sound", class_2960.field_25139).orElse(null);
        }
        if (nbt.method_10545("custom_name")) {
            name = NbtBlockUtils.getCustomNameFromNbt(nbt, registry, "custom_name");
        }
        if (nbt.method_10545("profile")) {
            profile = nbt.method_67491("profile", class_9296.field_49359).orElse(null);
        }
        return Pair.of(profile, (Object)Pair.of((Object)note, (Object)name));
    }

    public static Reference2IntOpenHashMap<class_5321<class_1860<?>>> getRecipesUsedFromNbt(@Nonnull class_2487 nbt) {
        UnboundedMapCodec CODEC = Codec.unboundedMap((Codec)class_1860.field_56667, (Codec)Codec.INT);
        Reference2IntOpenHashMap list = new Reference2IntOpenHashMap();
        if (nbt.method_10545("RecipesUsed")) {
            list.putAll(nbt.method_67491("RecipesUsed", (Codec)CODEC).orElse(Map.of()));
        }
        return list;
    }

    public static int getOutputSignalFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10545("OutputSignal")) {
            return nbt.method_68083("OutputSignal", 0);
        }
        return 0;
    }

    public static Optional<class_8966.class_11350> getTrialSpawnerDataFromNbt(@Nonnull class_2487 nbt) {
        return NbtUtils.readFlatMap(nbt, class_8966.class_11350.field_60376);
    }
}

